/******************************************************************************
 * @file: CAmActionFactory.cpp
 *
 * This file contains the definition of Action factory class used to
 * provide interface for creating various actions instance

 * @component: AudioManager Generic Controller
 *
 * @author: Naohiro Nishiguchi<nnishiguchi@jp.adit-jv.com>
 *          Kapildev Patel, Nilkanth Ahirrao <kpatel@jp.adit-jv.com>
 *
 * @copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *****************************************************************************/

#include "CAmActionFactory.h"
#include "CAmClassActionConnect.h"
#include "CAmClassActionSetVolume.h"
#include "CAmClassActionSuspend.h"
#include "CAmClassActionInterrupt.h"
#include "CAmClassActionDisconnect.h"
#include "CAmMainConnectionActionConnect.h"
#include "CAmMainConnectionActionDisconnect.h"
#include "CAmMainConnectionActionSetVolume.h"
#include "CAmMainConnectionActionSuspend.h"
#include "CAmSinkActionSetVolume.h"
#include "CAmSourceActionSetVolume.h"
#include "CAmSourceActionSetState.h"
#include "CAmRouteActionConnect.h"
#include "CAmRouteActionDisconnect.h"
#include "CAmSystemActionRegister.h"
#include "CAmSystemActionSetProperty.h"

namespace am {
namespace gc {

CAmActionFactory* CAmActionFactory::mpActionFactory = NULL;

CAmActionFactory::CAmActionFactory()
{
    mActionFactoryMap["CAmClassActionConnect"] = &CAmClassActionConnect::create;
    mActionFactoryMap["CAmClassActionSetVolume"] = &CAmClassActionSetVolume::create;
    mActionFactoryMap["CAmClassActionSuspend"] = &CAmClassActionSuspend::create;
    mActionFactoryMap["CAmClassActionInterrupt"] = &CAmClassActionInterrupt::create;
    mActionFactoryMap["CAmClassActionDisconnect"] = &CAmClassActionDisconnect::create;

    mActionFactoryMap["CAmMainConnectionActionConnect"] = &CAmMainConnectionActionConnect::create;
    mActionFactoryMap["CAmMainConnectionActionDisconnect"] = &CAmMainConnectionActionDisconnect::create;
    mActionFactoryMap["CAmMainConnectionActionSetVolume"] = &CAmMainConnectionActionSetVolume::create;
    mActionFactoryMap["CAmMainConnectionActionSuspend"] = &CAmMainConnectionActionSuspend::create;

    mActionFactoryMap["CAmSinkActionSetVolume"] = &CAmSinkActionSetVolume::create;
    mActionFactoryMap["CAmSourceActionSetVolume"] = &CAmSourceActionSetVolume::create;
    mActionFactoryMap["CAmSourceActionSetState"] = &CAmSourceActionSetState::create;
    mActionFactoryMap["CAmRouteActionConnect"] = &CAmRouteActionConnect::create;
    mActionFactoryMap["CAmRouteActionDisconnect"] = &CAmRouteActionDisconnect::create;

    mActionFactoryMap["CAmSystemActionRegister"] = &CAmSystemActionRegister::create;
    mActionFactoryMap["CAmSystemActionSetProperty"] = &CAmSystemActionSetProperty::create;
}

CAmActionFactory::~CAmActionFactory()
{
    mActionFactoryMap.clear();
}

CAmActionFactory* CAmActionFactory::getInstance()
{
    if (mpActionFactory == NULL)
    {
        mpActionFactory = new CAmActionFactory();
    }
    return mpActionFactory;
}

IAmActionCommand * CAmActionFactory::createAction(const string& actionName,CAmElement* pElement)
{
    std::map<std::string, createActionFn >::iterator itActionFactoryMap = mActionFactoryMap.find(actionName);
    if (itActionFactoryMap != mActionFactoryMap.end())
    {
        return itActionFactoryMap->second(pElement);
    }
    return NULL;
}

void CAmActionFactory::freeInstance()
{
    if (mpActionFactory != NULL)
    {
        delete mpActionFactory;
        mpActionFactory = NULL;
    }
}

} /* namespace gc */
} /* namespace am */
